﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;
using Inet.Viewer.Resources;

namespace Inet.Viewer.WinForms.Prompt
{
    /// <summary>
    /// Responsible for a panel for entering a single prompt value (WITHOUT default values)
    /// </summary>
    public partial class SinglePromptField : PromptControl
    {
        private string oldTextIfNoValueNotChecked;

        /// <summary>
        /// Simple constructor for creating this panel for the given PromptData
        /// </summary>
        /// <param name="p1">PromptData to create this panel for.</param>
        /// <param name="validationDelegate">delegate to call when validation is over</param>
        public SinglePromptField(Data.PromptData p1, ValidationDelegate validationDelegate)
        {
            this.PromptData = p1;
            InitializeComponent();
            this.txtValueBox.TextChanged += new System.EventHandler(this.HandleChanged);

            this.AutoValidate = AutoValidate.Disable;
            PromptValue alreadySelectedValue = p1.Values;
            this.chkNoValue.Visible = p1.type == PromptData.String && !p1.MultipleAllowed && p1.MinValue == null;
            if (this.chkNoValue.Visible)
            {
                if (alreadySelectedValue.Value == null)
                {
                    this.chkNoValue.Checked = true;
                }
                else
                {
                    this.txtValueBox.Text = alreadySelectedValue.ValueString;
                }
            }
            else
            {
                if (alreadySelectedValue != null && alreadySelectedValue.Value != null && !p1.MultipleAllowed)
                {
                    this.txtValueBox.Text = alreadySelectedValue.ValueString;
                }
            }
            if (p1.EditMask == "password")
            {
                txtValueBox.UseSystemPasswordChar = true;                
            }
            ErrorProvider = errorProvider;
            ControlForErrors = chkNoValue.Visible ? (Control)this.chkNoValue : (Control)this.txtValueBox;
        }

        /// <summary>
        /// Called when the "no value" checkbox is checked: sets the value to null
        /// </summary>
        /// <param name="sender">button being checked</param>
        /// <param name="e">args of the event</param>
        internal void chkNoValue_CheckedChanged(object sender, EventArgs e)
        {
            if (!this.chkNoValue.Visible)
            {
                return;
            }
            if (this.chkNoValue.Checked)
            {
                oldTextIfNoValueNotChecked = this.txtValueBox.Text;
                this.txtValueBox.Text = '<' + strings.Prompt_None_Long + '>';
                this.txtValueBox.Enabled = false;
            }
            else
            {
                if (oldTextIfNoValueNotChecked == null)
                {
                    oldTextIfNoValueNotChecked = "";
                }
                this.txtValueBox.Text = oldTextIfNoValueNotChecked;
                this.txtValueBox.Enabled = true;
            }
            ValidatePrompt();
            OnValueChanged();
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        internal override Data.PromptValue Value
        {
            get {
                if (this.chkNoValue.Checked || (!this.chkNoValue.Visible && this.txtValueBox.Text.Length == 0 && PromptData.Type != PromptData.String))
                {
                    return new Data.SinglePromptValue(null, "", this.PromptData.Type);
                }
                return new Data.SinglePromptValue(
                    this.PromptData.type,
                    this.txtValueBox.Text);
            }
        }
    }
}
